*******************************************************************
*                                                                 *
* Published in the Ledgers Disk Magazine Volume 8                 *
*                                           Release Date : 1/2/92 *
*                                                                 *
*******************************************************************

* This source displays a realtime starfield, and does everything but rotate
* about the X and/or Y axis, but it still looks pretty nice and uses 6
* colours to give a better sense of depth......
* Remove the +$80000 below to make it work on half meg.
* If you use this source, credit me (Powerman of The Wild Boys) for it or
* I'll kill you....

SCREEN1		EQU $70000+$80000
SCREEN2		EQU $78000+$80000
NUM_STARS	EQU (80/6)*6		must divide by 6
STAR_DEPTH	EQU 500
COL1		EQU $222
COL2		EQU $333
COL4		EQU $444
COL3		EQU $555
COL6		EQU $666
COL5		EQU $777
RANGE		EQU STAR_DEPTH			
DUMMY		EQU RANGE+1
TIME		EQU 512

		MOVE.L A7,STACK
		LEA MY,A7

		CLR.L -(A7)
		MOVE.W #32,-(A7)
		TRAP #1		
		ADDQ.L #6,A7
		
		MOVE.L #SCREEN1,SCR1
		MOVE.L #SCREEN2,SCR2
		JSR INIT
		JSR SET_UP
		JSR MAIN
		JSR END

		MOVE.L STACK,-(A7)
		MOVE.W #32,-(A7)
		TRAP #1		
		ADDQ.L #6,A7

		CLR.L -(A7)
		TRAP #1

MAIN		MOVE.W #$2300,SR
		LEA $FFFF8242.W,A0
		MOVE.W #COL1,(A0)+
		MOVE.W #COL2,(A0)+
		MOVE.W #COL3,(A0)+
		MOVE.W #COL4,(A0)+
		MOVE.W #COL5,(A0)+
		MOVE.W #COL6,(A0)+
		MOVE.W #COL6,(A0)+

.L1		JSR DO_STARS
		JSR SWAP
		JSR DO_ROUT
		CMPI.B #57,$FFFFFC02.W
		BNE .L1
.L2		RTS

DO_ROUT		SUBQ.W #1,TIMER
		BGE .L1
		MOVE.W #TIME,TIMER
		MOVE.L POS,A0
		CMPI.L #900,(A0)
		BNE .L2
		LEA STAR_ROUTS,A0
.L2		MOVE.L (A0)+,STAR_SPEED
		CLR.W D0
		MOVE.L A0,ROUT_START
.L4		TST.L (A0)+
		BMI .L3
		ADDQ.W #1,D0
		BRA.S .L4
.L3		MOVE.W D0,NUM_ROUTS
		MOVE.L A0,POS
.L1		MOVE.L STAR_SPEED,D5
		MOVE.L ROUT_START,A5
		MOVE.W NUM_ROUTS,D7
		SUBQ.W #1,D7
.L5		MOVE.L (A5)+,A6
		JSR (A6)
		DBF D7,.L5
		RTS

;speed,routs,-1
STAR_ROUTS	DC.L 8,FORWARD,-1
		DC.L 8,UP,FORWARD,ROTATE_CLOCK,-1
		DC.L 16,LEFT,ROTATE_ANTI,-1
		DC.L 16,RIGHT,ROTATE_CLOCK,-1
		DC.L 16,DOWN,BACKWARD,-1
		DC.L 8,BACKWARD,ROTATE_CLOCK,-1
		DC.L 8,FORWARD,LEFT,-1
		DC.L 900

POS		DS.L 1
TIMER		DS.W 1
STAR_SPEED	DS.L 1
NUM_ROUTS	DS.W 1
ROUT_START	DS.L 1

SET_UP		MOVE.L #SCREEN1,PHYSIC
		MOVE.L #SCREEN2,LOGIC
		JSR INIT_STARS
		MOVE.L #STAR_ROUTS,POS
		MOVE.W #-1,TIMER
		RTS

WAITVBL		CLR.B VBLFLAG
.L1		TST.B VBLFLAG
		BEQ .L1
		RTS

LOGIC		DS.L 1
PHYSIC		DS.L 1

SWAP		MOVEM.L LOGIC,D0-D1
		MOVE.L D0,D2
		LSR.W #8,D2
		MOVE.L D2,$FFFF8200.W
		BSR WAITVBL
		EXG D0,D1
		MOVEM.L D0-D1,LOGIC
		TST.W OFF
		BEQ.S .L1
		CLR.W OFF
		RTS
.L1		MOVE.W #4,OFF
		RTS

INIT		MOVE.W #$2700,SR
		DC.W $A000		
		DC.W $A00A		
		MOVE.B #$12,D0		
		BSR IKBD		
		LEA $FFFF8240.W,A0
		MOVEQ.W #8-1,D0
.COLS		MOVE.L #0,(A0)+
		DBF D0,.COLS
		MOVEQ.L #0,D1
		MOVE.L SCR1,A0
		CMP.L SCR2,A0
		BEQ .L222
		MOVE.L SCR2,A1
		MOVE.L A1,A2
.L33		CMPA.L A0,A2
		BEQ .L2
		MOVE.L D1,(A0)+
		MOVE.L D1,(A1)+
		BRA .L33		
.L222		MOVE.W #32000/4-1,D0
.L22		MOVE.L D1,(A0)+
		DBF D0,.L22
.L2		LEA VARS,A0
		MOVE.L $70.W,(A0)+
		MOVE.L $120.W,(A0)+
		MOVE.L $118.W,(A0)+
		MOVE.L $134.W,(A0)+
		MOVE.L $68.W,(A0)+
		MOVE.B $FFFFFA07.W,(A0)+
		MOVE.B $FFFFFA09.W,(A0)+
		MOVE.B $FFFFFA13.W,(A0)+
		MOVE.B $FFFFFA1B.W,(A0)+
		MOVE.B $FFFFFA21.W,(A0)+
		MOVE.B $FFFFFA15.W,(A0)+
		MOVE.B $FFFFFA19.W,(A0)+
		MOVE.B $FFFFFA1F.W,(A0)+
		MOVE.B $FFFFFA15.W,(A0)+
		MOVE.L #VBL,$70.W		
		MOVE.L #RTE,$68.W
		MOVE.L #RTE,$134.W
		MOVE.L #KEY,$118.W
		MOVE.L SCR1,D0
		LSR.W #8,D0
		MOVE.W #$2300,SR
		CLR.B VBLFLAG
.WAITVBL	TST.B VBLFLAG
		BEQ .WAITVBL
		MOVE.L D0,$FFFF8200.W
		CLR.B $FFFF8260.W
		MOVE.B #2,$FFFF820A.W
		MOVE.W #$2700,SR
		CLR.B $FFFFFA07.W
		CLR.B $FFFFFA09.W
		CLR.B $FFFFFA13.W
		CLR.B $FFFFFA15.W
		ORI.B #1,$FFFFFA07.W		TIMER B ENABLE
		ORI.B #1,$FFFFFA13.W
		ORI.B #64,$FFFFFA09.W		KEYBOARD ENABLE
		ORI.B #64,$FFFFFA15.W
		RTS
SCR1		DS.L 1
SCR2		DS.L 1
VARS		DS.B 32
VBL		ST VBLFLAG
RTE		RTE
VBLFLAG		DC.W 0
KEY		MOVE.B $FFFFFC02.W,PRESS
		BCLR #6,$FFFFFA11.W
		RTE
PRESS		DC.W 0	
WAITKEY		MOVE.W #$2300,SR
		CLR.B PRESS
.L1		CMPI.B #57+128,PRESS
		BNE .L1
		RTS
END		MOVE.W #$2700,SR
		LEA $FFFF8800.W,A0
		MOVE.L #$700FF00,(A0)
		MOVE.L #$8000000,(A0)
		MOVE.L #$9000000,(A0)
		MOVE.L #$A000000,(A0)
		LEA VARS,A0
		MOVE.L (A0)+,$70.W
		MOVE.L (A0)+,$120.W
		MOVE.L (A0)+,$118.W
		MOVE.L (A0)+,$134.W
		MOVE.L (A0)+,$68.W
		MOVE.B (A0)+,$FFFFFA07.W
		MOVE.B (A0)+,$FFFFFA09.W
		MOVE.B (A0)+,$FFFFFA13.W
		MOVE.B (A0)+,$FFFFFA1B.W
		MOVE.B (A0)+,$FFFFFA21.W
		MOVE.B (A0)+,$FFFFFA15.W
		MOVE.B (A0)+,$FFFFFA19.W
		MOVE.B (A0)+,$FFFFFA1F.W
		MOVE.B (A0)+,$FFFFFA15.W
		MOVE.W #$777,$FFFF8240.W
		MOVE.W #0,$FFFF8242.W
		MOVE.W #0,$FFFF8246.W
		DC.W $A000
		DC.W $A009
		MOVE.B #8,D0
		BSR IKBD
		MOVE.W #1,-(A7)
		PEA $78000+$80000
		PEA $78000+$80000
		MOVE.W #5,-(A7)
		TRAP #14
		LEA 12(A7),A7
		MOVE.W #$2300,SR
		RTS

STACK		DS.L 1

IKBD		LEA $FFFFFC00.W,A0
.L1		MOVE.B (A0),D1
		BTST #1,D1
		BEQ .L1
		MOVE.B D0,2(A0)
		RTS

		DS.L 400
MY		DS.L 1


***************************************************************************
* 3D STARFIELD ROUTINE, CODED BY POWERMAN OF TWB FOR THE 3RD TWB MEGADEMO *
* (C) THE WILD BOYS, 19/10/91						  *
***************************************************************************
;PS:the 3rd TWB megademo has been cancelled, which is why you are now able
;   to look at this source....

INIT_STARS	JSR MAKE_STAR_DATA
		MOVE.L #DIV0,$14.W
		RTS

DIV0		RTE

DO_STARS	JSR ERASE_STARS

		JSR ROTATE_POINTS
		JSR SORT
		JSR PERSPECT
		
		LEA ERASE,A0
		MOVE.W OFF,D0
		MOVE.L (A0,D0.W),A0
		MOVE.L LOGIC,A1
		LEA SCREEN,A2
		LEA Y,A3
		MOVE.W #319,D3
		MOVE.W #199,D4

COLOUR1		MOVE.W #NUM_STARS/6-1,D0
.L1		MOVEM.W (A2)+,D1/D2
		TST.W D1
		BMI .L2
		TST.W D2
		BMI .L2
		CMP.W D3,D1
		BGT .L2
		CMP.W D4,D2
		BGT .L2
		ADD.W D2,D2
		MOVE.W (A3,D2.W),D2	
		MOVE.W D1,D5
		AND.W #$FFF0,D5
		LSR.W #1,D5
		ADD.W D5,D2
		MOVE.W D2,(A0)+
		NOT.W D1
		AND.W #15,D1
		CLR.W D5
		BSET D1,D5
		OR.W D5,(A1,D2.W)	
.L2		DBF D0,.L1
COLOUR2		MOVE.W #NUM_STARS/6-1,D0
.L1		MOVEM.W (A2)+,D1/D2
		TST.W D1
		BMI .L2
		TST.W D2
		BMI .L2
		CMP.W D3,D1
		BGT .L2
		CMP.W D4,D2
		BGT .L2
		ADD.W D2,D2
		MOVE.W (A3,D2.W),D2	
		MOVE.W D1,D5
		AND.W #$FFF0,D5
		LSR.W #1,D5
		ADD.W D5,D2
		MOVE.W D2,(A0)+
		NOT.W D1
		AND.W #15,D1
		CLR.W D5
		BSET D1,D5
		OR.W D5,2(A1,D2.W)	
.L2		DBF D0,.L1
COLOUR3		MOVE.W #NUM_STARS/6-1,D0
.L1		MOVEM.W (A2)+,D1/D2
		TST.W D1
		BMI .L2
		TST.W D2
		BMI .L2
		CMP.W D3,D1
		BGT .L2
		CMP.W D4,D2
		BGT .L2
		ADD.W D2,D2
		MOVE.W (A3,D2.W),D2	
		MOVE.W D1,D5
		AND.W #$FFF0,D5
		LSR.W #1,D5
		ADD.W D5,D2
		MOVE.W D2,(A0)+
		NOT.W D1
		AND.W #15,D1
		CLR.W D5
		BSET D1,D5
		OR.W D5,4(A1,D2.W)	
.L2		DBF D0,.L1
COLOUR4		MOVE.W #NUM_STARS/6-1,D0
.L1		MOVEM.W (A2)+,D1/D2
		TST.W D1
		BMI .L2
		TST.W D2
		BMI .L2
		CMP.W D3,D1
		BGT .L2
		CMP.W D4,D2
		BGT .L2
		ADD.W D2,D2
		MOVE.W (A3,D2.W),D2	
		MOVE.W D1,D5
		AND.W #$FFF0,D5
		LSR.W #1,D5
		ADD.W D5,D2
		MOVE.W D2,(A0)+
		NOT.W D1
		AND.W #15,D1
		CLR.W D5
		BSET D1,D5
		OR.W D5,0(A1,D2.W)	
		OR.W D5,2(A1,D2.W)	
.L2		DBF D0,.L1
COLOUR5		MOVE.W #NUM_STARS/6-1,D0
.L1		MOVEM.W (A2)+,D1/D2
		TST.W D1
		BMI .L2
		TST.W D2
		BMI .L2
		CMP.W D3,D1
		BGT .L2
		CMP.W D4,D2
		BGT .L2
		ADD.W D2,D2
		MOVE.W (A3,D2.W),D2	
		MOVE.W D1,D5
		AND.W #$FFF0,D5
		LSR.W #1,D5
		ADD.W D5,D2
		MOVE.W D2,(A0)+
		NOT.W D1
		AND.W #15,D1
		CLR.W D5
		BSET D1,D5
		OR.W D5,2(A1,D2.W)	
		OR.W D5,4(A1,D2.W)	
.L2		DBF D0,.L1
COLOUR6		MOVE.W #NUM_STARS/6-1,D0
.L1		MOVEM.W (A2)+,D1/D2
		TST.W D1
		BMI .L2
		TST.W D2
		BMI .L2
		CMP.W D3,D1
		BGT .L2
		CMP.W D4,D2
		BGT .L2
		ADD.W D2,D2
		MOVE.W (A3,D2.W),D2	
		MOVE.W D1,D5
		AND.W #$FFF0,D5
		LSR.W #1,D5
		ADD.W D5,D2
		MOVE.W D2,(A0)+
		NOT.W D1
		AND.W #15,D1
		CLR.W D5
		BSET D1,D5
		OR.W D5,(A1,D2.W)	
		OR.W D5,4(A1,D2.W)	
.L2		DBF D0,.L1
		RTS

Y
OFFSET		SET 0
		REPT 200
		DC.W OFFSET
OFFSET		SET OFFSET+160
		ENDR

ERASE_STARS	LEA ERASE,A0
		MOVE.W OFF,D0
		MOVE.L (A0,D0.W),A0

		MOVE.L LOGIC,A1
		CLR.L D0
		MOVE.W #NUM_STARS/6-1,D1
.L1		MOVEM.W (A0)+,D2-D7
		MOVE.L D0,(A1,D2.W)
		MOVE.W D0,4(A1,D2.W)
		MOVE.L D0,(A1,D3.W)
		MOVE.W D0,4(A1,D3.W)
		MOVE.L D0,(A1,D4.W)
		MOVE.W D0,4(A1,D4.W)
		MOVE.L D0,(A1,D5.W)
		MOVE.W D0,4(A1,D5.W)
		MOVE.L D0,(A1,D6.W)
		MOVE.W D0,4(A1,D6.W)
		MOVE.L D0,(A1,D7.W)
		MOVE.W D0,4(A1,D7.W)
		DBF D1,.L1
		RTS

ERASE		DC.L ERASE1,ERASE2
ERASE1		DCB.W NUM_STARS,0
ERASE2		DCB.W NUM_STARS,0
OFF		DC.W 0

RANDOM		MOVE.W SEED,D0
		MULU #1221,D0
		MOVE.W D0,SEED
		RTS
SEED		DC.W 'AB'

MAKE_STAR_DATA	LEA STAR_COORDS,A0
		MOVE.W #NUM_STARS-1,D2
.L1		BSR RANDOM
		AND.L #$0000FFFF,D0
		MOVE.L D0,D1
		DIVU #200+200,D0
		DIVU #320+200,D1
		SWAP D0
		SWAP D1
		MOVE.W D1,(A0)+
		MOVE.W D0,(A0)+
		DBF D2,.L1

		MOVE.W #160+100,D0
		MOVE.W #100+100,D1
		MOVE.W #0,D5			d5=start Z
		MOVE.W #STAR_DEPTH/NUM_STARS,D6
		LEA STAR_COORDS,A0
		LEA WORLD,A1
		MOVE.W #NUM_STARS-1,D2	
		MOVE.W D2,NUM_POINTS
.L2		MOVEM.W (A0)+,D3-D4
		SUB.W D0,D3
		SUB.W D1,D4
		MOVEM.W D3-D4,(A1)
		MOVE.W D5,4(A1)
		ADDQ.L #6,A1
		ADD.W D6,D5
		DBF D2,.L2
		RTS	

STAR_COORDS	DS.L NUM_STARS

********************************** 3D ROUTINES ****************************
* ALL 3D ROUTINE CODING BY POWERMAN OF THE WILD BOYS			  *
* Y AXIS SHOULD BE TREATED AS UPSIDE DOWN (-VE IS TOP, +VE IS BOTTOM)	  *
* USES 512 ENTRY SINE TABLE						  *
***************************************************************************
DIST		DC.W 256		Perspective
WORLD		DS.W NUM_STARS*3	X,Y,Z coords for each point		
VIEW		DS.W NUM_STARS*4	X,Y,blank,z coords for each rotated point
SCREEN		DS.W NUM_STARS*2	Screen X,Y coords
NUM_POINTS	DS.W 1			Number of points in current object-1
MATRIX		DS.W 9
XROT		DC.W 0			X rotation angle
YROT		DC.W 0			Y rotation angle
ZROT		DC.W 0			Z rotation angle
XOFFSET		DC.W 0			Offset on X axis
YOFFSET		DC.W 0			Offset on Y axis
ZOFFSET		DC.W 0			Offset on Z axis
SINCOS		DS.W 6			Space for x,y,z sine/cosine

ROTATE_POINTS	LEA SINTAB,A0
		LEA 128*2(A0),A2	COSINE=SINE+128 DEGREES
		LEA SINCOS,A1
		MOVE.W ZROT,D2
		MOVE.W #512,D6
		MOVE.W #-512,D5

.L5		CMP.W D5,D2
		BGT .L6
		ADD.W D6,D2
		BRA .L7
.L6		CMP.W D6,D2
		BLT .L7
		SUB.W D6,D2

.L7		MOVE.W D2,ZROT
.L9		TST.W D2
		BPL .L10
		ADD.W D6,D2

.L10		CLR.W D0
		CLR.W D1	
		ADD.W D2,D2
		MOVE.W (A0,D0.W),(A1)+		Sine x   (0)
		MOVE.W (A2,D0.W),(A1)+		Cosine x (2)
		MOVE.W (A0,D1.W),(A1)+		Sine y   (4)
		MOVE.W (A2,D1.W),(A1)+		Cosine y (6)
		MOVE.W (A0,D2.W),(A1)+		Sine z   (8)
		MOVE.W (A2,D2.W),(A1)		Cosine z (10)
		LEA -10(A1),A1

		MOVE.W 4(A1),D0			SIN(Y)
		MOVE.W D0,D1		
		MULS 8(A1),D0			SIN(Z)*SIN(Y)
		LSL.L #1,D0
		SWAP D0				D0=SIN(Z)*SIN(Y)
		 	
		NEG.W D1			-SIN(Y)
		MULS 10(A1),D1			COS(Z)
		LSL.L #1,D1
		SWAP D1				D1=-SIN(Y)*COS(Z)

		LEA MATRIX,A2
;MATRIX(1,1) 	
		MOVE.W 10(A1),D2
		MOVE.W D2,D6
		MULS 6(A1),D2
		LSL.L #1,D2
		SWAP D2
		MOVE.W D2,(A2)+
;MATRIX(1,2)	
		MOVE.W (A1),D2
		MULS D1,D2
		MOVE.W 8(A1),D3
		MOVE.W D3,D4
		MOVE.W D4,D5
		MULS 2(A1),D3
		SUB.L D2,D3
		LSL.L #1,D3
		SWAP D3
		MOVE.W D3,(A2)+		
;MATRIX(1,3)	
		MOVE.W 2(A1),D2
		MULS D1,D2
		MULS (A1),D4
		ADD.L D2,D4
		LSL.L #1,D4
		SWAP D4
		MOVE.W D4,(A2)+		
;MATRIX(2,1)	
		NEG.W D5
		MULS 6(A1),D5
		LSL.L #1,D5
		SWAP D5
		MOVE.W D5,(A2)+
;MATRIX(2,2)	
		MOVE.W D6,D5
		MULS 2(A1),D6
		MOVE.W (A1),D3
		MULS D0,D3
		SUB.L D3,D6
		LSL.L #1,D6
		SWAP D6
		MOVE.W D6,(A2)+
;MATRIX(2,3)	
		MULS (A1),D5
		MOVE.W 2(A1),D3
		MOVE.W D3,D6
		MULS D0,D3
		ADD.L D3,D5
		LSL.L #1,D5
		SWAP D5
		MOVE.W D5,(A2)+

		MOVE.W NUM_POINTS,D6
		LEA WORLD,A0
		LEA VIEW,A1
		LEA MATRIX,A2
.L1		MOVE.L A2,A3
		MOVEM.W (A0)+,D0-D2		D0-D2=x,y,z coords
		MOVE.W D0,D3
		MOVE.W D1,D4
		MOVE.W D2,D5		
.CALC_X_COORD	MULS (A3)+,D0			
		MULS (A3)+,D1
		MULS (A3)+,D2
		ADD.L D0,D1
		ADD.L D2,D1
		LSL.L #1,D1
		SWAP D1
		MOVE.W D1,(A1)+
.CALC_Y_COORD	MULS (A3)+,D3
		MULS (A3)+,D4
		MOVE.W D5,-(A7)
		MULS (A3)+,D5
		ADD.L D3,D4
		ADD.L D5,D4
		LSL.L #1,D4
		SWAP D4 
		MOVE.W D4,(A1)+
.CALC_Z_COORD	ADDQ.L #2,A1
		MOVE.W (A7)+,(A1)+
		DBF D6,.L1
		RTS

XCENT		DC.W 160
YCENT		DC.W 100

PERSPECT	MOVEM.W XCENT,D0-D1
		LEA VIEW,A0
		LEA SCREEN,A1
		MOVE.W NUM_POINTS,D2
		MOVE.W DIST,D5
		MOVEQ.W #8,D7

.L1		MOVEM.W (A0)+,D3/D4/D6/A2
		EXG D6,A2
		EXT.L D3
		EXT.L D4
		ASL.L D7,D3			
		ASL.L D7,D4			

		ADD.W D5,D6
		DIVS D6,D3			DIVIDE X BY DIST+Z
		DIVS D6,D4			DIVIDE Y BY DIST+Z
		ADD.W D0,D3
		ADD.W D1,D4

		MOVEM.W D3-D4,(A1)
		ADDQ.L #4,A1
		DBF D2,.L1	
		RTS

SINTAB		DC.W 0,402,804,1206,1608,2009,2411,2811
		DC.W 3212,3612,4011,4410,4808,5205,5602,5998
		DC.W 6393,6787,7180,7571,7962,8351,8740,9127
		DC.W 9512,9896,10279,10660,11039,11417,11793,12167
 		DC.W 12540,12910,13279,13646,14010,14373,14733,15091
 		DC.W 15447,15800,16151,16500,16846,17190,17531,17869
 		DC.W 18205,18538,18868,19195,19520,19841,20160,20475
 		DC.W 20788,21097,21403,21706,22006,22302,22595,22884
 		DC.W 23170,23453,23732,24008,24279,24548,24812,25073
 		DC.W 25330,25583,25833,26078,26320,26557,26791,27020
 		DC.W 27246,27467,27684,27897,28106,28311,28511,28707
 		DC.W 28899,29086,29269,29448,29622,29792,29957,30118
 		DC.W 30274,30425,30572,30715,30853,30986,31114,31238
 		DC.W 31357,31471,31581,31686,31786,31881,31972,32058
 		DC.W 32138,32214,32286,32352,32413,32470,32522,32568
 		DC.W 32610,32647,32679,32706,32729,32746,32758,32766

 		DC.W 32767,32766,32758,32746,32729,32706,32679,32647
 		DC.W 32610,32568,32522,32470,32413,32352,32286,32214
 		DC.W 32138,32058,31972,31881,31786,31686,31581,31471
 		DC.W 31357,31238,31114,30986,30853,30715,30572,30425
 		DC.W 30274,30118,29957,29792,29622,29448,29269,29086
 		DC.W 28899,28707,28511,28311,28106,27897,27684,27467
 		DC.W 27246,27020,26791,26557,26320,26078,25833,25583
 		DC.W 25330,25073,24812,24548,24279,24008,23732,23453
 		DC.W 23170,22884,22595,22302,22006,21706,21403,21097
 		DC.W 20788,20475,20160,19841,19520,19195,18868,18538
 		DC.W 18205,17869,17531,17190,16846,16500,16151,15800
 		DC.W 15447,15091,14733,14373,14010,13646,13279,12910
 		DC.W 12540,12167,11793,11417,11039,10660,10279,9896
 		DC.W 9512,9127,8740,8351,7962,7571,7180,6787
 		DC.W 6393,5998,5602,5205,4808,4410,4011,3612
 		DC.W 3212,2811,2411,2009,1608,1206,804,402
 
		DC.W 0,-402,-804,-1206,-1608,-2009,-2411,-2811
 		DC.W -3212,-3612,-4011,-4410,-4808,-5205,-5602,-5998
 		DC.W -6393,-6787,-7180,-7571,-7962,-8351,-8740,-9127
 		DC.W -9512,-9896,-10279,-10660,-11039,-11417,-11793,-12167
 		DC.W -12540,-12910,-13279,-13646,-14010,-14373,-14733,-15091
 		DC.W -15447,-15800,-16151,-16500,-16846,-17190,-17531,-17869
 		DC.W -18205,-18538,-18868,-19195,-19520,-19841,-20160,-20475
 		DC.W -20788,-21097,-21403,-21706,-22006,-22302,-22595,-22884
 		DC.W -23170,-23453,-23732,-24008,-24279,-24548,-24812,-25073
 		DC.W -25330,-25583,-25833,-26078,-26320,-26557,-26791,-27020
 		DC.W -27246,-27467,-27684,-27897,-28106,-28311,-28511,-28707
 		DC.W -28899,-29086,-29269,-29448,-29622,-29792,-29957,-30118
 		DC.W -30274,-30425,-30572,-30715,-30853,-30986,-31114,-31238
 		DC.W -31357,-31471,-31581,-31686,-31786,-31881,-31972,-32058
 		DC.W -32138,-32214,-32286,-32352,-32413,-32470,-32522,-32568
 		DC.W -32610,-32647,-32679,-32706,-32729,-32746,-32758,-32766

 		DC.W -32767,-32766,-32758,-32746,-32729,-32706,-32679,-32647
 		DC.W -32610,-32568,-32522,-32470,-32413,-32352,-32286,-32214
 		DC.W -32138,-32058,-31972,-31881,-31786,-31686,-31581,-31471
 		DC.W -31357,-31238,-31114,-30986,-30853,-30715,-30572,-30425
 		DC.W -30274,-30118,-29957,-29792,-29622,-29448,-29269,-29086
 		DC.W -28899,-28707,-28511,-28311,-28106,-27897,-27684,-27467
 		DC.W -27246,-27020,-26791,-26557,-26320,-26078,-25833,-25583
 		DC.W -25330,-25073,-24812,-24548,-24279,-24008,-23732,-23453
 		DC.W -23170,-22884,-22595,-22302,-22006,-21706,-21403,-21097
 		DC.W -20788,-20475,-20160,-19841,-19520,-19195,-18868,-18538
 		DC.W -18205,-17869,-17531,-17190,-16846,-16500,-16151,-15800
 		DC.W -15447,-15091,-14733,-14373,-14010,-13646,-13279,-12910
 		DC.W -12540,-12167,-11793,-11417,-11039,-10660,-10279,-9896
 		DC.W -9512,-9127,-8740,-8351,-7962,-7571,-7180,-6787
 		DC.W -6393,-5998,-5602,-5205,-4808,-4410,-4011,-3612
 		DC.W -3212,-2811,-2411,-2009,-1608,-1206,-804,-402

* DUPLICATE FIRST 128 ENTRIES FOR COSINE OVERLAP

 		DC.W 0,402,804,1206,1608,2009,2411,2811
 		DC.W 3212,3612,4011,4410,4808,5205,5602,5998
 		DC.W 6393,6787,7180,7571,7962,8351,8740,9127
 		DC.W 9512,9896,10279,10660,11039,11417,11793,12167
 		DC.W 12540,12910,13279,13646,14010,14373,14733,15091
 		DC.W 15447,15800,16151,16500,16846,17190,17531,17869
 		DC.W 18205,18538,18868,19195,19520,19841,20160,20475
 		DC.W 20788,21097,21403,21706,22006,22302,22595,22884
 		DC.W 23170,23453,23732,24008,24279,24548,24812,25073
 		DC.W 25330,25583,25833,26078,26320,26557,26791,27020
 		DC.W 27246,27467,27684,27897,28106,28311,28511,28707
 		DC.W 28899,29086,29269,29448,29622,29792,29957,30118
 		DC.W 30274,30425,30572,30715,30853,30986,31114,31238
 		DC.W 31357,31471,31581,31686,31786,31881,31972,32058
 		DC.W 32138,32214,32286,32352,32413,32470,32522,32568
 		DC.W 32610,32647,32679,32706,32729,32746,32758,32766

;ultra fast sort rout....
SORT		LEA VIEW,A0
		MOVE.W NUM_POINTS,D0

		MOVE.W #RANGE,D2

		LEA TEMPDATA,A1
		MOVE.L A0,A2
		MOVE.W D0,D1
.L4		MOVEM.L (A0)+,D4/D5
		MOVE.W D2,D3
		SUB.W D5,D3
		LSL.W #3,D3			*8
		MOVEM.L D4/D5,(A1,D3.W)
		DBF D0,.L4

		LEA TEMPDATA,A1
		MOVE.W #DUMMY,D3
.L5		MOVEM.L (A1)+,D0/D2
		CMP.W D0,D3
		BEQ.S .L5
		MOVEM.L D0/D2,(A2)
		ADDQ.L #8,A2
		MOVE.W D3,-6(A1)
		DBF D1,.L5
		RTS

FORWARD		;D5=speed
		LEA WORLD,A0
		MOVE.W #STAR_DEPTH,D0
		MOVE.W #NUM_STARS-1,D1
.L1		MOVEM.W (A0)+,D2-D4
		SUB.W D5,D4
		BGE .L2
		ADD.W D0,D4
.L2		MOVE.W D4,-2(A0)		
		DBF D1,.L1
		RTS

BACKWARD	;D5=speed
		LEA WORLD,A0
		MOVE.W #STAR_DEPTH,D0
		MOVE.W #NUM_STARS-1,D1
.L1		MOVEM.W (A0)+,D2-D4
		ADD.W D5,D4
		CMP.W D0,D4
		BLE .L2
		SUB.W D0,D4
.L2		MOVE.W D4,-2(A0)		
		DBF D1,.L1
		RTS

LEFT		;D5=speed
		LEA WORLD,A0
		MOVE.W #320+200,D0
		MOVE.W #-260,D6
		MOVE.W #NUM_STARS-1,D1
.L1		MOVEM.W (A0)+,D2-D4
		SUB.W D5,D2
		CMP.W D6,D2
		BGE .L2
		ADD.W D0,D2
.L2		MOVE.W D2,-6(A0)		
		DBF D1,.L1
		RTS

RIGHT		;D5=speed
		LEA WORLD,A0
		MOVE.W #320+200,D0
		MOVE.W #260,D6
		MOVE.W #NUM_STARS-1,D1
.L1		MOVEM.W (A0)+,D2-D4
		ADD.W D5,D2
		CMP.W D6,D2
		BLE .L2
		SUB.W D0,D2
.L2		MOVE.W D2,-6(A0)		
		DBF D1,.L1
		RTS

UP		;D5=speed
		LEA WORLD,A0
		MOVE.W #200+200,D0
		MOVE.W #-200,D6
		MOVE.W #NUM_STARS-1,D1
.L1		MOVEM.W (A0)+,D2-D4
		SUB.W D5,D3
		CMP.W D6,D3
		BGE .L2
		ADD.W D0,D3
.L2		MOVE.W D3,-4(A0)		
		DBF D1,.L1
		RTS

DOWN		;D5=speed
		LEA WORLD,A0
		MOVE.W #200+200,D0
		MOVE.W #200,D6
		MOVE.W #NUM_STARS-1,D1
.L1		MOVEM.W (A0)+,D2-D4
		ADD.W D5,D3
		CMP.W D6,D3
		BLE .L2
		SUB.W D0,D3
.L2		MOVE.W D3,-4(A0)		
		DBF D1,.L1
		RTS

ROTATE_CLOCK	SUBQ.W #1,ZROT
		RTS
ROTATE_ANTI	ADDQ.W #1,ZROT
		RTS

TEMPDATA	

